/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.mod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MATagRecipeJS
extends RecipeJS {
    private final List<String> pattern = new ArrayList<String>();
    private final List<String> key = new ArrayList<String>();

    @Override
    public void create(ListJS args) {
        throw new RecipeExceptionJS("Can't create recipe with this type! Use regular shaped crafting");
    }

    @Override
    public void deserialize() {
        for (JsonElement e : this.json.get("pattern").getAsJsonArray()) {
            this.pattern.add(e.getAsString());
        }
        if (this.pattern.isEmpty()) {
            throw new RecipeExceptionJS("Pattern is empty!");
        }
        for (Map.Entry entry : this.json.get("key").getAsJsonObject().entrySet()) {
            this.inputItems.add(this.parseIngredientItem(entry.getValue(), (String)entry.getKey()));
            this.key.add((String)entry.getKey());
        }
        if (this.key.isEmpty()) {
            throw new RecipeExceptionJS("Key map is empty!");
        }
    }

    @Override
    public void serialize() {
        if (this.serializeInputs) {
            JsonArray patternJson = new JsonArray();
            for (String s : this.pattern) {
                patternJson.add(s);
            }
            this.json.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            for (int i = 0; i < this.key.size(); ++i) {
                keyJson.add(this.key.get(i), ((IngredientJS)this.inputItems.get(i)).toJson());
            }
            this.json.add("key", (JsonElement)keyJson);
        }
    }
}

